//
//  NSXMLNode+MCAddtions.h
//  MCFoundation
//
//  Created by Alykhan Jetha on 09-09-07.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface NSXMLNode (MCAddtions)

/*!
 When you use this method instead of objectsForXQuery:error:, you are saying that you expect exactly one element to satisfy the query
 */
- (id)mcObjectValueForXQuery:(NSString *)aQuery;

- (NSString *)mcStringValueForXQuery:(NSString *)aQuery;
- (NSString *)mcNilSafeStringValueForXQuery:(NSString *)aQuery;

/*!
 Tries to coerce to an NSDecimalNumber. If there is no result for the query, then "0.00" is returned.
 */
- (NSDecimalNumber *)mcMoneyValueForXQuery:(NSString *)aQuery;

- (NSNumber *)mcIntegerValueForXQuery:(NSString *)aQuery;
/*!
 Tries to coerce to an NSCalendarDate using the XML standard yyyy-MM-ddTHH:mm:ss.
 Note: We'll have to change this to NSDate for 10.6
 */
- (NSCalendarDate *)mcCalendarDateValueForXQuery:(NSString *)aQuery;



@end
